<?php
require_once '../config/config.php';
requireLogin();
if (!isSuperAdmin()) redirect(SITE_URL . '/index.php');

$pageTitle = 'Platform Settings';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    validateCSRF();
    $db = getDB();
    
    foreach ($_POST as $key => $value) {
        if ($key !== 'csrf_token') {
            $db->prepare("UPDATE settings SET value = ? WHERE key_name = ?")->execute([sanitize($value), $key]);
        }
    }
    $success = 'Settings updated successfully.';
}

$db = getDB();
$stmt = $db->prepare("SELECT * FROM settings ORDER BY group_name, key_name");
$stmt->execute();
$settings = $stmt->fetchAll();

$grouped = [];
foreach ($settings as $setting) {
    $grouped[$setting['group_name']][] = $setting;
}

include '../templates/admin-header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php include 'sidebar.php'; ?>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <?php include 'header-bar.php'; ?>

            <?php if ($success): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <?php echo e($success); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <form method="POST">
                <?php echo csrfField(); ?>
                
                <?php foreach ($grouped as $group => $groupSettings): ?>
                <div class="card shadow mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><?php echo ucwords(str_replace('_', ' ', $group)); ?> Settings</h5>
                    </div>
                    <div class="card-body">
                        <?php foreach ($groupSettings as $setting): ?>
                        <div class="mb-3">
                            <label class="form-label">
                                <?php echo ucwords(str_replace('_', ' ', $setting['key_name'])); ?>
                            </label>
                            <?php if ($setting['type'] === 'boolean'): ?>
                                <select class="form-select" name="<?php echo $setting['key_name']; ?>">
                                    <option value="1" <?php echo $setting['value'] == '1' ? 'selected' : ''; ?>>Enabled</option>
                                    <option value="0" <?php echo $setting['value'] == '0' ? 'selected' : ''; ?>>Disabled</option>
                                </select>
                            <?php elseif ($setting['type'] === 'integer'): ?>
                                <input type="number" class="form-control" name="<?php echo $setting['key_name']; ?>" 
                                       value="<?php echo e($setting['value']); ?>">
                            <?php else: ?>
                                <input type="text" class="form-control" name="<?php echo $setting['key_name']; ?>" 
                                       value="<?php echo e($setting['value']); ?>">
                            <?php endif; ?>
                            <?php if ($setting['description']): ?>
                                <small class="form-text text-muted"><?php echo e($setting['description']); ?></small>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endforeach; ?>

                <div class="mb-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Settings
                    </button>
                </div>
            </form>
        </main>
    </div>
</div>

<?php include '../templates/footer.php'; ?>
