<?php
require_once '../config/config.php';
$pageTitle = 'About Us';
include '../templates/header.php';
?>

<?php 
    $aboutContactInfo = getContactInfo();
    $aboutCompanyName = !empty($aboutContactInfo['company_name']) ? $aboutContactInfo['company_name'] : getSiteName();
    $aboutTagline = !empty($aboutContactInfo['tagline']) ? $aboutContactInfo['tagline'] : '';
?>
<div class="container my-5">
    <h1 class="mb-4">About <?php echo e($aboutCompanyName); ?><?php if ($aboutTagline) { echo ' - <span class=\'small text-muted\'>' . e($aboutTagline) . '</span>'; } ?></h1>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h3>Our Mission</h3>
                    <p class="lead">To advance obstetrics and gynecology research through global collaboration, knowledge sharing, and innovative technology.</p>
                    
                    <hr>
                    
                    <h3>About the Platform</h3>
                    <p><?php echo e($aboutCompanyName); ?><?php if ($aboutTagline) { echo ' - <span class=\'small text-muted\'>' . e($aboutTagline) . '</span>'; } ?> is a comprehensive digital ecosystem designed specifically for obstetrics and gynecology researchers worldwide. Our platform facilitates seamless collaboration, research documentation, and knowledge exchange among medical professionals dedicated to advancing women's health.</p>
                    
                    <h4 class="mt-4">What We Offer</h4>
                    <ul>
                        <li><strong>Global Networking:</strong> Connect with researchers from around the world</li>
                        <li><strong>Research Management:</strong> Comprehensive tools for documenting and managing studies</li>
                        <li><strong>Collaboration Tools:</strong> Real-time messaging, file sharing, and team coordination</li>
                        <li><strong>Publication Hub:</strong> Share and discover published research</li>
                        <li><strong>Institutional Support:</strong> Features designed for research institutions and universities</li>
                        <li><strong>Security & Compliance:</strong> Enterprise-grade security with data protection compliance</li>
                    </ul>
                    
                    <h4 class="mt-4">Our Vision</h4>
                    <p>We envision a world where OBGYN researchers can seamlessly collaborate across borders, share knowledge freely, and accelerate medical breakthroughs that improve women's health globally.</p>
                    
                    <h4 class="mt-4">Core Values</h4>
                    <div class="row g-3 mt-2">
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h5><i class="fas fa-handshake text-primary"></i> Collaboration</h5>
                                    <p class="mb-0 small">Fostering partnerships and teamwork in research</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h5><i class="fas fa-shield-alt text-success"></i> Integrity</h5>
                                    <p class="mb-0 small">Maintaining highest ethical standards</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h5><i class="fas fa-lightbulb text-warning"></i> Innovation</h5>
                                    <p class="mb-0 small">Embracing new technologies and methodologies</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h5><i class="fas fa-users text-info"></i> Community</h5>
                                    <p class="mb-0 small">Building a supportive research community</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h5>Get Involved</h5>
                    <p class="small">Join our growing community of researchers</p>
                    <a href="<?php echo SITE_URL; ?>/register.php" class="btn btn-primary w-100 mb-2">Register Now</a>
                    <a href="contact.php" class="btn btn-outline-primary w-100">Contact Us</a>
                </div>
            </div>
            
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>Quick Links</h5>
                    <ul class="list-unstyled mb-0">
                        <li><a href="studies.php">Browse Studies</a></li>
                        <li><a href="researchers.php">Find Researchers</a></li>
                        <li><a href="publications.php">View Publications</a></li>
                        <li><a href="institutions.php">Institutions</a></li>
                        <li><a href="help.php">Help Center</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../templates/footer.php'; ?>
