<?php
require_once '../config/config.php';
$pageTitle = 'Compliance Information';
include '../templates/header.php';
?>

<?php 
    $complianceContactInfo = getContactInfo();
    $complianceCompanyName = !empty($complianceContactInfo['company_name']) ? $complianceContactInfo['company_name'] : getSiteName();
    $complianceTagline = !empty($complianceContactInfo['tagline']) ? $complianceContactInfo['tagline'] : '';
    $complianceEmail = !empty($complianceContactInfo['email_primary']) ? $complianceContactInfo['email_primary'] : SITE_EMAIL;
?>
<div class="container my-5">
    <h1 class="mb-4">Compliance Information - <?php echo e($complianceCompanyName); ?><?php if ($complianceTagline) { echo ' <span class=\'small text-muted\'>' . e($complianceTagline) . '</span>'; } ?></h1>
    
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h3>Data Protection & Privacy Compliance</h3>
                    <p><?php echo e($complianceCompanyName); ?> is committed to protecting your data and complying with international data protection regulations.</p>
                    
                    <h5>GDPR Compliance (EU)</h5>
                    <p>We comply with the General Data Protection Regulation (GDPR) for users in the European Union:</p>
                    <ul>
                        <li>Right to access your personal data</li>
                        <li>Right to rectification of inaccurate data</li>
                        <li>Right to erasure ("right to be forgotten")</li>
                        <li>Right to restrict processing</li>
                        <li>Right to data portability</li>
                        <li>Right to object to processing</li>
                        <li>Rights related to automated decision-making</li>
                    </ul>
                    
                    <h5>HIPAA Considerations (US)</h5>
                    <p>While our platform is not a covered entity under HIPAA, we implement security measures consistent with HIPAA standards for protecting health information:</p>
                    <ul>
                        <li>Encryption of data in transit and at rest</li>
                        <li>Access controls and authentication</li>
                        <li>Audit logging</li>
                        <li>Regular security assessments</li>
                    </ul>
                    
                    <h5>Data Localization</h5>
                    <p>We store data in secure data centers with appropriate physical and technical safeguards. Data location and transfer comply with applicable regulations.</p>
                </div>
            </div>
            
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h3>Research Ethics & Integrity</h3>
                    
                    <h5>Ethical Research Practices</h5>
                    <p>We promote and support ethical research practices:</p>
                    <ul>
                        <li>Respect for research participants</li>
                        <li>Informed consent requirements</li>
                        <li>Data integrity and accuracy</li>
                        <li>Proper attribution and citation</li>
                        <li>Conflict of interest disclosure</li>
                    </ul>
                    
                    <h5>Institutional Review Board (IRB)</h5>
                    <p>Researchers are responsible for obtaining appropriate IRB approval for their studies. The platform does not replace institutional ethics review processes.</p>
                    
                    <h5>Publication Ethics</h5>
                    <p>We adhere to international standards for publication ethics:</p>
                    <ul>
                        <li>Originality and plagiarism prevention</li>
                        <li>Proper authorship attribution</li>
                        <li>Peer review integrity</li>
                        <li>Correction and retraction policies</li>
                    </ul>
                </div>
            </div>
            
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h3>Security Standards</h3>
                    
                    <h5>Technical Security Measures</h5>
                    <ul>
                        <li><strong>Encryption:</strong> TLS 1.3 for data in transit, AES-256 for data at rest</li>
                        <li><strong>Authentication:</strong> Multi-factor authentication (2FA) available</li>
                        <li><strong>Access Control:</strong> Role-based access control (RBAC)</li>
                        <li><strong>Monitoring:</strong> 24/7 security monitoring and logging</li>
                        <li><strong>Backups:</strong> Regular automated backups with encryption</li>
                    </ul>
                    
                    <h5>Organizational Security</h5>
                    <ul>
                        <li>Regular security training for staff</li>
                        <li>Incident response procedures</li>
                        <li>Third-party security audits</li>
                        <li>Vulnerability management program</li>
                    </ul>
                </div>
            </div>
            
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h3>Accessibility Compliance</h3>
                    <p>We strive to make our platform accessible to all users, including those with disabilities, in accordance with:</p>
                    <ul>
                        <li>Web Content Accessibility Guidelines (WCAG) 2.1 Level AA</li>
                        <li>Section 508 of the Rehabilitation Act (US)</li>
                        <li>European Accessibility Act</li>
                    </ul>
                </div>
            </div>
            
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h3>Reporting & Transparency</h3>
                    
                    <h5>Data Breach Notification</h5>
                    <p>In the event of a data breach, we will:</p>
                    <ul>
                        <li>Notify affected users within 72 hours</li>
                        <li>Report to relevant authorities as required</li>
                        <li>Provide details of the breach and remediation steps</li>
                        <li>Offer support and guidance to affected users</li>
                    </ul>
                    
                    <h5>Transparency Reports</h5>
                    <p>We publish annual transparency reports detailing:</p>
                    <ul>
                        <li>Data requests from authorities</li>
                        <li>Security incidents</li>
                        <li>Platform usage statistics</li>
                        <li>Compliance updates</li>
                    </ul>
                </div>
            </div>
            
            <div class="card shadow-sm">
                <div class="card-body">
                    <h3>Contact Information</h3>
                    <p>For compliance-related inquiries:</p>
                    <ul>
                        <li><strong>Data Protection Officer:</strong> <a href="mailto:<?php echo e($complianceEmail); ?>"><?php echo e($complianceEmail); ?></a></li>
                        <li><strong>Security Team:</strong> <a href="mailto:<?php echo e($complianceEmail); ?>"><?php echo e($complianceEmail); ?></a></li>
                        <li><strong>Ethics Committee:</strong> <a href="mailto:<?php echo e($complianceEmail); ?>"><?php echo e($complianceEmail); ?></a></li>
                    </ul>
                    
                    <p class="mb-0">For general inquiries, please visit our <a href="contact.php">Contact Page</a>.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../templates/footer.php'; ?>
