<?php
require_once '../config/config.php';
$pageTitle = 'Help Center';
include '../templates/header.php';
?>

<?php 
    $helpContactInfo = getContactInfo();
    $helpCompanyName = !empty($helpContactInfo['company_name']) ? $helpContactInfo['company_name'] : getSiteName();
    $helpTagline = !empty($helpContactInfo['tagline']) ? $helpContactInfo['tagline'] : '';
?>
<div class="container my-5">
    <h1 class="mb-4">Help Center - <?php echo e($helpCompanyName); ?><?php if ($helpTagline) { echo ' <span class=\'small text-muted\'>' . e($helpTagline) . '</span>'; } ?></h1>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h3>Getting Started</h3>
                    <div class="accordion" id="gettingStarted">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#register">
                                    How do I register?
                                </button>
                            </h2>
                            <div id="register" class="accordion-collapse collapse show" data-bs-parent="#gettingStarted">
                                <div class="accordion-body">
                                    Click the "Register" button, fill in your details, and verify your email address. Once verified, you can start using the platform.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#profile">
                                    How do I complete my profile?
                                </button>
                            </h2>
                            <div id="profile" class="accordion-collapse collapse" data-bs-parent="#gettingStarted">
                                <div class="accordion-body">
                                    After logging in, go to your dashboard and click "Edit Profile". Add your bio, specialization, institution, and other details.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h3>Research & Studies</h3>
                    <div class="accordion" id="research">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#createStudy">
                                    How do I create a study?
                                </button>
                            </h2>
                            <div id="createStudy" class="accordion-collapse collapse" data-bs-parent="#research">
                                <div class="accordion-body">
                                    Navigate to your dashboard, click "Create Study", fill in the study details, and submit for approval.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collaborate">
                                    How do I add collaborators?
                                </button>
                            </h2>
                            <div id="collaborate" class="accordion-collapse collapse" data-bs-parent="#research">
                                <div class="accordion-body">
                                    Open your study, click "Manage Collaborators", search for researchers, and send collaboration invitations.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card shadow-sm">
                <div class="card-body">
                    <h3>Account & Security</h3>
                    <div class="accordion" id="security">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#password">
                                    How do I reset my password?
                                </button>
                            </h2>
                            <div id="password" class="accordion-collapse collapse" data-bs-parent="#security">
                                <div class="accordion-body">
                                    Click "Forgot Password" on the login page, enter your email, and follow the instructions sent to your email.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#2fa">
                                    How do I enable 2FA?
                                </button>
                            </h2>
                            <div id="2fa" class="accordion-collapse collapse" data-bs-parent="#security">
                                <div class="accordion-body">
                                    Go to Settings > Security, enable Two-Factor Authentication, and scan the QR code with your authenticator app.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card shadow-sm mb-4">
                <div class="card-body">
                    <h5>Quick Links</h5>
                    <ul class="list-unstyled">
                        <li><a href="faq.php"><i class="fas fa-question-circle"></i> FAQ</a></li>
                        <li><a href="contact.php"><i class="fas fa-envelope"></i> Contact Support</a></li>
                        <li><a href="about.php"><i class="fas fa-info-circle"></i> About Us</a></li>
                    </ul>
                </div>
            </div>
            
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>Need More Help?</h5>
                    <p class="small">Can't find what you're looking for?</p>
                    <a href="contact.php" class="btn btn-primary w-100">Contact Us</a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../templates/footer.php'; ?>
