<?php
require_once '../config/config.php';
$pageTitle = 'Browse Publications';

$search = $_GET['search'] ?? '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$perPage = 15;
$offset = ($page - 1) * $perPage;

$db = getDB();
$where = ["p.status = 'published'", "p.approval_status = 'approved'"];
$params = [];

if (!empty($search)) {
    $where[] = "(p.title LIKE ? OR p.abstract LIKE ? OR p.journal LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

$whereClause = implode(' AND ', $where);

$stmt = $db->prepare("SELECT COUNT(*) FROM publications p WHERE $whereClause");
$stmt->execute($params);
$totalPubs = $stmt->fetchColumn();
$totalPages = ceil($totalPubs / $perPage);

$stmt = $db->prepare("
    SELECT p.*, u.first_name, u.last_name
    FROM publications p
    JOIN users u ON p.user_id = u.id
    WHERE $whereClause
    ORDER BY p.publication_date DESC
    LIMIT $perPage OFFSET $offset
");
$stmt->execute($params);
$publications = $stmt->fetchAll();

include '../templates/header.php';
?>

<div class="container my-5">
    <h2 class="mb-4"><i class="fas fa-book"></i> Browse Publications</h2>
    
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-8">
                    <input type="text" class="form-control" name="search" value="<?php echo e($search); ?>" placeholder="Search publications...">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100"><i class="fas fa-search"></i> Search</button>
                </div>
                <div class="col-md-2">
                    <a href="publications.php" class="btn btn-outline-secondary w-100"><i class="fas fa-redo"></i> Reset</a>
                </div>
            </form>
        </div>
    </div>
    
    <p class="text-muted mb-4">Found <?php echo number_format($totalPubs); ?> publications</p>
    
    <?php foreach ($publications as $pub): ?>
    <div class="card shadow-sm mb-3">
        <div class="card-body">
            <h5><a href="publication-detail.php?id=<?php echo $pub['id']; ?>" class="text-decoration-none"><?php echo e($pub['title']); ?></a></h5>
            <p class="text-muted mb-2">
                <i class="fas fa-user"></i> <?php echo e($pub['first_name'] . ' ' . $pub['last_name']); ?> | 
                <i class="fas fa-book"></i> <?php echo e($pub['journal'] ?? 'N/A'); ?> | 
                <i class="fas fa-calendar"></i> <?php echo date('Y', strtotime($pub['publication_date'])); ?>
            </p>
            <?php if ($pub['abstract']): ?>
                <p class="small"><?php echo e(substr($pub['abstract'], 0, 200)); ?>...</p>
            <?php endif; ?>
            <a href="publication-detail.php?id=<?php echo $pub['id']; ?>" class="btn btn-sm btn-outline-primary">Read More</a>
        </div>
    </div>
    <?php endforeach; ?>
    
    <?php if ($totalPages > 1): ?>
    <nav class="mt-4">
        <ul class="pagination justify-content-center">
            <?php for ($i = 1; $i <= min($totalPages, 10); $i++): ?>
            <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
                <a class="page-link" href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>"><?php echo $i; ?></a>
            </li>
            <?php endfor; ?>
        </ul>
    </nav>
    <?php endif; ?>
</div>

<?php include '../templates/footer.php'; ?>
