<?php
require_once '../config/config.php';
$pageTitle = 'Terms of Service';
include '../templates/header.php';
?>

<?php 
    $termsContactInfo = getContactInfo();
    $termsCompanyName = !empty($termsContactInfo['company_name']) ? $termsContactInfo['company_name'] : getSiteName();
    $termsTagline = !empty($termsContactInfo['tagline']) ? $termsContactInfo['tagline'] : '';
    $termsEmail = !empty($termsContactInfo['email_primary']) ? $termsContactInfo['email_primary'] : SITE_EMAIL;
    $termsPhone = !empty($termsContactInfo['phone_primary']) ? $termsContactInfo['phone_primary'] : '';
?>
<div class="container my-5">
    <h1 class="mb-4">Terms of Service - <?php echo e($termsCompanyName); ?><?php if ($termsTagline) { echo ' <span class=\'small text-muted\'>' . e($termsTagline) . '</span>'; } ?></h1>
    
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="card shadow-sm">
                <div class="card-body">
                    <p class="text-muted">Last Updated: January 10, 2025</p>
                    
                    <h3>1. Acceptance of Terms</h3>
                    <p>By accessing and using <?php echo e($termsCompanyName); ?><?php if ($termsTagline) { echo ' - <span class=\'small text-muted\'>' . e($termsTagline) . '</span>'; } ?>, you accept and agree to be bound by the terms and provision of this agreement.</p>
                    
                    <h3>2. Use License</h3>
                    <p>Permission is granted to temporarily access the materials on <?php echo e($termsCompanyName); ?> for personal, non-commercial transitory viewing only.</p>
                    
                    <h3>3. User Accounts</h3>
                    <p>When you create an account with us, you must provide accurate, complete, and current information. Failure to do so constitutes a breach of the Terms.</p>
                    <ul>
                        <li>You are responsible for safeguarding your password</li>
                        <li>You must not share your account with others</li>
                        <li>You must notify us immediately of any unauthorized use</li>
                    </ul>
                    
                    <h3>4. Acceptable Use</h3>
                    <p>You agree not to use the platform:</p>
                    <ul>
                        <li>For any unlawful purpose</li>
                        <li>To solicit others to perform unlawful acts</li>
                        <li>To violate any international, federal, provincial or state regulations</li>
                        <li>To infringe upon or violate our intellectual property rights</li>
                        <li>To harass, abuse, insult, harm, defame, slander, disparage, intimidate, or discriminate</li>
                        <li>To submit false or misleading information</li>
                        <li>To upload or transmit viruses or any other type of malicious code</li>
                    </ul>
                    
                    <h3>5. Intellectual Property</h3>
                    <p>The platform and its original content, features, and functionality are owned by <?php echo e($termsCompanyName); ?> and are protected by international copyright, trademark, patent, trade secret, and other intellectual property laws.</p>
                    
                    <h3>6. User Content</h3>
                    <p>You retain all rights to any content you submit, post or display on or through the platform. By posting content, you grant us a worldwide, non-exclusive, royalty-free license to use, reproduce, and distribute such content.</p>
                    
                    <h3>7. Research Data</h3>
                    <p>All research data uploaded to the platform remains the property of the researcher. We do not claim ownership of your research data.</p>
                    
                    <h3>8. Termination</h3>
                    <p>We may terminate or suspend your account immediately, without prior notice or liability, for any reason whatsoever, including without limitation if you breach the Terms.</p>
                    
                    <h3>9. Limitation of Liability</h3>
                    <p>In no event shall <?php echo e($termsCompanyName); ?>, nor its directors, employees, partners, agents, suppliers, or affiliates, be liable for any indirect, incidental, special, consequential or punitive damages.</p>
                    
                    <h3>10. Disclaimer</h3>
                    <p>Your use of the platform is at your sole risk. The platform is provided on an "AS IS" and "AS AVAILABLE" basis.</p>
                    
                    <h3>11. Changes to Terms</h3>
                    <p>We reserve the right to modify or replace these Terms at any time. We will provide notice of any changes by posting the new Terms on this page.</p>
                    
                    <h3>12. Contact Us</h3>
                    <p>If you have any questions about these Terms, please contact us at <a href="mailto:<?php echo e($termsEmail); ?>"><?php echo e($termsEmail); ?></a><?php if ($termsPhone) { echo ' or call <a href=\'tel:' . e($termsPhone) . '\'>' . e($termsPhone) . '</a>'; } ?>.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../templates/footer.php'; ?>
