<?php
require_once 'config/config.php';
$db = getDB();

echo "Testing researcher profile access:\n";

// Test with a researcher that should work
$userId = 1; // Ahmed Sherif
$stmt = $db->prepare("
    SELECT u.*, rp.*, i.name as institution_name
    FROM users u
    LEFT JOIN researcher_profiles rp ON u.id = rp.user_id
    LEFT JOIN institutions i ON rp.institution_id = i.id
    WHERE u.id = ? AND u.role_id = ? AND u.status = 'active'
");
$stmt->execute([$userId, ROLE_RESEARCHER]);
$researcher = $stmt->fetch();

if ($researcher) {
    echo "Researcher ID $userId found: " . $researcher['first_name'] . ' ' . $researcher['last_name'] . "\n";
} else {
    echo "Researcher ID $userId NOT found\n";
}

// Test with a researcher that might not work
$userId = 27; // Yara Barakat (no profile)
$stmt->execute([$userId, ROLE_RESEARCHER]);
$researcher = $stmt->fetch();

if ($researcher) {
    echo "Researcher ID $userId found: " . $researcher['first_name'] . ' ' . $researcher['last_name'] . "\n";
} else {
    echo "Researcher ID $userId NOT found\n";
}

echo "\nSITE_URL: " . SITE_URL . "\n";
echo "Redirect URL would be: " . SITE_URL . '/public/researchers.php' . "\n";
?>