<?php
/**
 * Admin Dashboard Sidebar
 * Shared sidebar component for all admin pages
 */

// Get current page for active state
$currentPage = basename($_SERVER['PHP_SELF']);

// Get counts for badges
$db = getDB();

// Pending users count
$stmt = $db->prepare("SELECT COUNT(*) FROM users WHERE status = 'pending'");
$stmt->execute();
$pendingUsers = $stmt->fetchColumn();

// Pending studies count
$stmt = $db->prepare("SELECT COUNT(*) FROM studies WHERE approval_status = 'pending'");
$stmt->execute();
$pendingStudies = $stmt->fetchColumn();

// Pending publications count
$stmt = $db->prepare("SELECT COUNT(*) FROM publications WHERE approval_status = 'pending'");
$stmt->execute();
$pendingPublications = $stmt->fetchColumn();
?>

<nav class="col-md-3 col-lg-2 d-md-block bg-dark sidebar">
    <div class="position-sticky pt-3">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'dashboard.php' ? 'active' : ''; ?>" href="dashboard.php">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'users.php' ? 'active' : ''; ?>" href="users.php">
                    <i class="fas fa-users"></i> Users
                    <?php if ($pendingUsers > 0): ?>
                        <span class="badge bg-warning"><?php echo $pendingUsers; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'studies.php' ? 'active' : ''; ?>" href="studies.php">
                    <i class="fas fa-flask"></i> Studies
                    <?php if ($pendingStudies > 0): ?>
                        <span class="badge bg-warning"><?php echo $pendingStudies; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'publications.php' ? 'active' : ''; ?>" href="publications.php">
                    <i class="fas fa-book"></i> Publications
                    <?php if ($pendingPublications > 0): ?>
                        <span class="badge bg-warning"><?php echo $pendingPublications; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'institutions.php' ? 'active' : ''; ?>" href="institutions.php">
                    <i class="fas fa-university"></i> Institutions
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'categories.php' ? 'active' : ''; ?>" href="categories.php">
                    <i class="fas fa-tags"></i> Categories
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'moderation.php' ? 'active' : ''; ?>" href="moderation.php">
                    <i class="fas fa-shield-alt"></i> Moderation
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'analytics.php' ? 'active' : ''; ?>" href="analytics.php">
                    <i class="fas fa-chart-line"></i> Analytics
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'audit-logs.php' ? 'active' : ''; ?>" href="audit-logs.php">
                    <i class="fas fa-history"></i> Audit Logs
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'settings.php' ? 'active' : ''; ?>" href="settings.php">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </li>
        </ul>
        
        <hr class="my-3" style="border-color: rgba(255,255,255,0.1);">
        
        <!-- CMS Section -->
        <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
            <span>CONTENT MANAGEMENT</span>
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'cms-pages.php' ? 'active' : ''; ?>" href="cms-pages.php">
                    <i class="fas fa-file-alt"></i> Pages
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'cms-contact.php' ? 'active' : ''; ?>" href="cms-contact.php">
                    <i class="fas fa-address-card"></i> Contact Info
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'cms-posts.php' ? 'active' : ''; ?>" href="cms-posts.php">
                    <i class="fas fa-newspaper"></i> Blog Posts
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'cms-menus.php' ? 'active' : ''; ?>" href="cms-menus.php">
                    <i class="fas fa-bars"></i> Menus
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link disabled text-muted" href="#" style="cursor: not-allowed;">
                    <i class="fas fa-images"></i> Media Library <small>(Coming Soon)</small>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link disabled text-muted" href="#" style="cursor: not-allowed;">
                    <i class="fas fa-home"></i> Homepage <small>(Coming Soon)</small>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link disabled text-muted" href="#" style="cursor: not-allowed;">
                    <i class="fas fa-palette"></i> Branding <small>(Coming Soon)</small>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link disabled text-muted" href="#" style="cursor: not-allowed;">
                    <i class="fas fa-user-friends"></i> Team <small>(Coming Soon)</small>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link disabled text-muted" href="#" style="cursor: not-allowed;">
                    <i class="fas fa-bullhorn"></i> Announcements <small>(Coming Soon)</small>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link disabled text-muted" href="#" style="cursor: not-allowed;">
                    <i class="fas fa-envelope"></i> Email Templates <small>(Coming Soon)</small>
                </a>
            </li>
        </ul>
        
        <hr class="my-3" style="border-color: rgba(255,255,255,0.1);">
        
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link" href="<?php echo SITE_URL; ?>/index.php">
                    <i class="fas fa-home"></i> View Site
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo SITE_URL; ?>/logout.php">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </li>
        </ul>
    </div>
</nav>

<style>
.sidebar {
    position: fixed;
    top: 56px;
    bottom: 0;
    left: 0;
    z-index: 100;
    padding: 0;
    box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
    overflow-y: auto;
}

.sidebar .nav-link {
    font-weight: 500;
    color: rgba(255, 255, 255, 0.8);
    padding: 0.75rem 1rem;
    transition: all 0.3s;
}

.sidebar .nav-link:hover {
    background-color: rgba(255, 255, 255, 0.1);
    color: #fff;
}

.sidebar .nav-link.active {
    color: #fff;
    background-color: rgba(255, 255, 255, 0.15);
    border-left: 3px solid #007bff;
}

.sidebar .nav-link i {
    margin-right: 0.5rem;
}

.sidebar-heading {
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.05rem;
    font-weight: 600;
}

main {
    margin-top: 56px;
}
</style>
