<?php
require_once __DIR__ . '/../config/database.php';

try {
    $db = getDB();
    $stmt = $db->query('SELECT u.first_name, u.last_name, rp.photo FROM users u JOIN researcher_profiles rp ON u.id = rp.user_id WHERE u.id = 125 LIMIT 1');
    $researcher = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($researcher) {
        echo 'Researcher: ' . $researcher['first_name'] . ' ' . $researcher['last_name'] . "\n";
        echo 'Photo path: ' . $researcher['photo'] . "\n";
        echo 'UPLOADS_URL: ' . UPLOADS_URL . "\n";
        echo 'Full URL: ' . UPLOADS_URL . '/' . $researcher['photo'] . "\n";
    } else {
        echo 'Researcher not found' . "\n";
    }
} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage() . "\n";
}
?>