<?php
require_once __DIR__ . '/../config/database.php';

try {
    $db = getDB();
    $stmt = $db->query('SELECT u.id, u.first_name, u.last_name, rp.photo FROM users u JOIN researcher_profiles rp ON u.id = rp.user_id WHERE u.role_id = (SELECT id FROM roles WHERE name = "researcher" LIMIT 1) AND rp.photo IS NOT NULL ORDER BY u.id DESC LIMIT 10');
    $researchers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo 'Researchers with photos:' . "\n";
    foreach ($researchers as $r) {
        echo $r['id'] . ': ' . $r['first_name'] . ' ' . $r['last_name'] . ' - ' . $r['photo'] . "\n";
    }

    // Check total researchers
    $stmt = $db->query('SELECT COUNT(*) as count FROM users WHERE role_id = (SELECT id FROM roles WHERE name = "researcher" LIMIT 1)');
    $result = $stmt->fetch();
    echo "\nTotal researchers: " . $result['count'] . "\n";

    // Check researchers with photos
    $stmt = $db->query('SELECT COUNT(*) as count FROM researcher_profiles WHERE photo IS NOT NULL AND photo != ""');
    $result = $stmt->fetch();
    echo 'Researchers with photos: ' . $result['count'] . "\n";

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage() . "\n";
}
?>