<?php
$uploadsDir = __DIR__ . '/../assets/uploads/profile_pictures/';

// Create uploads directory if it doesn't exist
if (!is_dir($uploadsDir)) {
    mkdir($uploadsDir, 0755, true);
}

$imageUrl = "https://picsum.photos/300/300?random=1";
$imagePath = $uploadsDir . "test.jpg";

echo "Downloading from: {$imageUrl}\n";
echo "Saving to: {$imagePath}\n";
echo "Directory writable: " . (is_writable($uploadsDir) ? 'Yes' : 'No') . "\n";

$imageData = file_get_contents($imageUrl);
if ($imageData !== false) {
    echo "Downloaded " . strlen($imageData) . " bytes\n";
    $bytesWritten = file_put_contents($imagePath, $imageData);
    if ($bytesWritten !== false) {
        echo "Wrote {$bytesWritten} bytes\n";
        echo "File exists: " . (file_exists($imagePath) ? 'Yes' : 'No') . "\n";
        echo "File size: " . filesize($imagePath) . " bytes\n";
    } else {
        echo "Write failed\n";
    }
} else {
    echo "Download failed\n";
}
?>