<?php
require_once '../config/config.php';
requireLogin();
if (!isSuperAdmin() && !isInstitutionAdmin()) redirect(SITE_URL . '/index.php');

$pageTitle = 'Publication Moderation';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    validateCSRF();
    $action = $_POST['action'] ?? '';
    $pubId = isset($_POST['pub_id']) ? (int)$_POST['pub_id'] : 0;
    $db = getDB();
    $userId = getCurrentUserId();
    
    if ($action === 'approve' && $pubId) {
        $db->prepare("UPDATE publications SET approval_status = 'approved', approved_by = ? WHERE id = ?")->execute([$userId, $pubId]);
        $success = 'Publication approved.';
    } elseif ($action === 'reject' && $pubId) {
        $db->prepare("UPDATE publications SET approval_status = 'rejected' WHERE id = ?")->execute([$pubId]);
        $success = 'Publication rejected.';
    }
}

$filter = $_GET['filter'] ?? 'all';
$db = getDB();
$where = $filter === 'pending' ? "WHERE p.approval_status = 'pending'" : '';

$stmt = $db->prepare("
    SELECT p.*, u.first_name, u.last_name
    FROM publications p
    JOIN users u ON p.user_id = u.id
    $where
    ORDER BY p.created_at DESC
    LIMIT 50
");
$stmt->execute();
$publications = $stmt->fetchAll();

include '../templates/admin-header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php include 'sidebar-new.php'; ?>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <?php include 'header-bar.php'; ?>

            <?php if ($success): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <?php echo e($success); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="card shadow mb-4">
                <div class="card-body">
                    <a href="?filter=all" class="btn btn-sm btn-<?php echo $filter === 'all' ? 'primary' : 'outline-primary'; ?>">All</a>
                    <a href="?filter=pending" class="btn btn-sm btn-<?php echo $filter === 'pending' ? 'warning' : 'outline-warning'; ?>">Pending</a>
                </div>
            </div>

            <div class="card shadow">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Author</th>
                                    <th>Journal</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($publications as $pub): ?>
                                <tr>
                                    <td><?php echo e(substr($pub['title'], 0, 50)); ?></td>
                                    <td><?php echo e($pub['first_name'] . ' ' . $pub['last_name']); ?></td>
                                    <td><?php echo e($pub['journal'] ?? 'N/A'); ?></td>
                                    <td><span class="badge bg-<?php echo $pub['approval_status'] === 'approved' ? 'success' : 'warning'; ?>"><?php echo ucfirst($pub['approval_status']); ?></span></td>
                                    <td><?php echo date('M d, Y', strtotime($pub['created_at'])); ?></td>
                                    <td>
                                        <?php if ($pub['approval_status'] === 'pending'): ?>
                                            <form method="POST" style="display:inline;">
                                                <?php echo csrfField(); ?>
                                                <input type="hidden" name="action" value="approve">
                                                <input type="hidden" name="pub_id" value="<?php echo $pub['id']; ?>">
                                                <button type="submit" class="btn btn-sm btn-success"><i class="fas fa-check"></i></button>
                                            </form>
                                            <form method="POST" style="display:inline;">
                                                <?php echo csrfField(); ?>
                                                <input type="hidden" name="action" value="reject">
                                                <input type="hidden" name="pub_id" value="<?php echo $pub['id']; ?>">
                                                <button type="submit" class="btn btn-sm btn-warning"><i class="fas fa-times"></i></button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<?php include '../templates/admin-footer.php'; ?>
