<?php
/**
 * Main Configuration File
 * OBGYN Research & Collaboration Platform
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Error reporting (set to 0 in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Timezone
date_default_timezone_set('UTC');

// Site Configuration
define('SITE_NAME', 'OBGYN Research Platform');

// Dynamic URL detection
if (!defined('SITE_URL')) {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    
    // Always include the obgyn-research-platform subdirectory
    $baseUrl = $protocol . '://' . $host . '/obgyn-research-platform';
    
    define('SITE_URL', rtrim($baseUrl, '/'));
}

// Define SITE_URL_DYNAMIC as alias for SITE_URL
if (!defined('SITE_URL_DYNAMIC')) {
    define('SITE_URL_DYNAMIC', SITE_URL);
}

define('SITE_EMAIL', 'admin@obgynresearch.com');
define('PLATFORM_VERSION', '1.5');

// Path Configuration
define('ROOT_PATH', dirname(dirname(__FILE__)));
define('INCLUDES_PATH', ROOT_PATH . '/includes');
define('TEMPLATES_PATH', ROOT_PATH . '/templates');
define('UPLOADS_PATH', ROOT_PATH . '/assets/uploads');
define('UPLOADS_URL', SITE_URL . '/assets/uploads');

// Upload Configuration
define('MAX_FILE_SIZE', 10485760); // 10MB in bytes
define('ALLOWED_FILE_TYPES', ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'jpg', 'jpeg', 'png', 'gif']);
define('ALLOWED_IMAGE_TYPES', ['jpg', 'jpeg', 'png', 'gif']);

// Security Configuration
define('HASH_ALGO', PASSWORD_BCRYPT);
define('HASH_COST', 12);
define('SESSION_LIFETIME', 3600); // 1 hour
define('REMEMBER_ME_LIFETIME', 2592000); // 30 days
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900); // 15 minutes

// Pagination
define('ITEMS_PER_PAGE', 20);
define('STUDIES_PER_PAGE', 15);
define('MESSAGES_PER_PAGE', 50);

// Email Configuration (using PHPMailer)
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'your-email@gmail.com');
define('SMTP_PASSWORD', 'your-app-password');
define('SMTP_ENCRYPTION', 'tls');
define('MAIL_FROM_EMAIL', SITE_EMAIL);
define('MAIL_FROM_NAME', SITE_NAME);

// User Roles
define('ROLE_SUPER_ADMIN', 1);
define('ROLE_INSTITUTION_ADMIN', 2);
define('ROLE_RESEARCHER', 3);
define('ROLE_GUEST', 4);

// Study Types
define('STUDY_TYPES', [
    'clinical' => 'Clinical',
    'surgical' => 'Surgical',
    'fertility' => 'Fertility',
    'urogynecology' => 'Urogynecology',
    'menopause' => 'Menopause',
    'other' => 'Other'
]);

// Study Status
define('STUDY_STATUS', [
    'draft' => 'Draft',
    'active' => 'Active',
    'completed' => 'Completed',
    'archived' => 'Archived',
    'pending_approval' => 'Pending Approval'
]);

// Institution Types
define('INSTITUTION_TYPES', [
    'university' => 'University',
    'hospital' => 'Hospital',
    'research_center' => 'Research Center',
    'clinic' => 'Clinic',
    'other' => 'Other'
]);

// Collaborator Roles
define('COLLABORATOR_ROLES', [
    'lead' => 'Lead Investigator',
    'co_investigator' => 'Co-Investigator',
    'statistician' => 'Statistician',
    'contributor' => 'Contributor',
    'reviewer' => 'Reviewer'
]);

// Languages
define('LANGUAGES', [
    'en' => 'English',
    'ar' => 'العربية'
]);

// Default Language
define('DEFAULT_LANGUAGE', 'en');

// Autoload includes
require_once INCLUDES_PATH . '/functions.php';
require_once INCLUDES_PATH . '/security.php';
require_once INCLUDES_PATH . '/auth.php';
require_once INCLUDES_PATH . '/rbac.php';

// Include database connection
require_once ROOT_PATH . '/config/database.php';

// Set default timezone from database settings (if available)
try {
    $db = getDB();
    $stmt = $db->prepare("SELECT value FROM settings WHERE key_name = 'timezone' LIMIT 1");
    $stmt->execute();
    $timezone = $stmt->fetchColumn();
    if ($timezone) {
        date_default_timezone_set($timezone);
    }
} catch (Exception $e) {
    // Settings table might not exist yet, use default
}
?>
