<?php
require_once '../config/config.php';

$isMobile = preg_match('/Mobile|Android|iPhone|iPad|iPod/', $_SERVER['HTTP_USER_AGENT']);
$pageTitle = 'Privacy Policy';
// Include appropriate header based on device
if ($isMobile) {
    include '../templates/mobile-header.php';
} else {
    include '../templates/header.php';
}
?>

<?php 
    $privacyContactInfo = getContactInfo();
    $privacyCompanyName = !empty($privacyContactInfo['company_name']) ? $privacyContactInfo['company_name'] : getSiteName();
    $privacyTagline = !empty($privacyContactInfo['tagline']) ? $privacyContactInfo['tagline'] : '';
    $privacyEmail = !empty($privacyContactInfo['email_primary']) ? $privacyContactInfo['email_primary'] : SITE_EMAIL;
?>
<div class="container my-5">
    <h1 class="mb-4">Privacy Policy - <?php echo e($privacyCompanyName); ?><?php if ($privacyTagline) { echo ' <span class=\'small text-muted\'>' . e($privacyTagline) . '</span>'; } ?></h1>
    
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="card shadow-sm">
                <div class="card-body">
                    <p class="text-muted">Last Updated: January 10, 2025</p>
                    
                    <h3>1. Information We Collect</h3>
                    <h5>Personal Information</h5>
                    <p>We collect information that you provide directly to us, including:</p>
                    <ul>
                        <li>Name and contact information (email, phone)</li>
                        <li>Professional information (institution, specialization)</li>
                        <li>Account credentials</li>
                        <li>Profile information and bio</li>
                        <li>Research data and publications</li>
                    </ul>
                    
                    <h5>Automatically Collected Information</h5>
                    <ul>
                        <li>IP address and device information</li>
                        <li>Browser type and version</li>
                        <li>Usage data and analytics</li>
                        <li>Cookies and similar technologies</li>
                    </ul>
                    
                    <h3>2. How We Use Your Information</h3>
                    <p>We use the information we collect to:</p>
                    <ul>
                        <li>Provide, maintain, and improve our services</li>
                        <li>Process your transactions and send related information</li>
                        <li>Send you technical notices and support messages</li>
                        <li>Respond to your comments and questions</li>
                        <li>Facilitate collaboration between researchers</li>
                        <li>Monitor and analyze trends and usage</li>
                        <li>Detect, prevent, and address technical issues</li>
                        <li>Comply with legal obligations</li>
                    </ul>
                    
                    <h3>3. Information Sharing</h3>
                    <p>We do not sell your personal information. We may share your information:</p>
                    <ul>
                        <li><strong>With other users:</strong> Your profile information and public research data</li>
                        <li><strong>With service providers:</strong> Who assist in operating our platform</li>
                        <li><strong>For legal reasons:</strong> When required by law or to protect rights</li>
                        <li><strong>With your consent:</strong> When you explicitly authorize sharing</li>
                    </ul>
                    
                    <h3>4. Data Security</h3>
                    <p>We implement appropriate technical and organizational measures to protect your personal information, including:</p>
                    <ul>
                        <li>Encryption of data in transit and at rest</li>
                        <li>Two-factor authentication</li>
                        <li>Regular security audits</li>
                        <li>Access controls and authentication</li>
                        <li>Secure data centers</li>
                    </ul>
                    
                    <h3>5. Data Retention</h3>
                    <p>We retain your personal information for as long as necessary to provide our services and fulfill the purposes outlined in this policy, unless a longer retention period is required by law.</p>
                    
                    <h3>6. Your Rights</h3>
                    <p>You have the right to:</p>
                    <ul>
                        <li>Access your personal information</li>
                        <li>Correct inaccurate data</li>
                        <li>Request deletion of your data</li>
                        <li>Object to processing of your data</li>
                        <li>Export your data</li>
                        <li>Withdraw consent</li>
                    </ul>
                    
                    <h3>7. Cookies</h3>
                    <p>We use cookies and similar tracking technologies to track activity on our platform. You can instruct your browser to refuse all cookies or to indicate when a cookie is being sent.</p>
                    
                    <h3>8. Third-Party Links</h3>
                    <p>Our platform may contain links to third-party websites. We are not responsible for the privacy practices of these external sites.</p>
                    
                    <h3>9. Children's Privacy</h3>
                    <p>Our platform is not intended for individuals under the age of 18. We do not knowingly collect personal information from children.</p>
                    
                    <h3>10. International Data Transfers</h3>
                    <p>Your information may be transferred to and maintained on computers located outside of your jurisdiction where data protection laws may differ.</p>
                    
                    <h3>11. Changes to Privacy Policy</h3>
                    <p>We may update this Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page and updating the "Last Updated" date.</p>
                    
                    <h3>12. Contact Us</h3>
                    <p>If you have questions about this Privacy Policy, please contact us:</p>
                    <ul>
                        <li>Email: <a href="mailto:<?php echo e($privacyEmail); ?>"><?php echo e($privacyEmail); ?></a></li>
                        <li><a href="contact.php">Contact Form</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php // Include appropriate footer based on device
if ($isMobile) {
    include '../templates/mobile-footer.php';
} else {
    include '../templates/footer.php';
} ?>
