<?php
/**
 * Researcher Dashboard Sidebar
 * Shared sidebar component for all researcher pages
 */

// Get current page for active state
$currentPage = basename($_SERVER['PHP_SELF']);

// Get notification counts
$db = getDB();
$userId = getCurrentUserId();

$stmt = $db->prepare("SELECT COUNT(*) FROM notifications WHERE user_id = ? AND is_read = 0");
$stmt->execute([$userId]);
$unreadNotifications = $stmt->fetchColumn();

$stmt = $db->prepare("SELECT COUNT(*) FROM study_collaborators WHERE user_id = ? AND status = 'pending'");
$stmt->execute([$userId]);
$pendingInvitations = $stmt->fetchColumn();

$stmt = $db->prepare("SELECT COUNT(*) FROM studies WHERE creator_id = ?");
$stmt->execute([$userId]);
$studiesCount = $stmt->fetchColumn();

// Get connection requests count
$stmt = $db->prepare("SELECT COUNT(*) FROM connections WHERE receiver_id = ? AND status = 'pending'");
$stmt->execute([$userId]);
$pendingConnections = $stmt->fetchColumn();

// Get unread messages count (FIXME: No receiver_id column in messages table)
$unreadMessages = 0; // Placeholder until correct logic is implemented
?>

<nav class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse" id="sidebarMenu">
    <div class="position-sticky pt-3">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'dashboard.php' ? 'active' : ''; ?>" href="dashboard.php">
                    <i class="fas fa-home"></i> Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo in_array($currentPage, ['profile.php', 'edit-profile.php']) ? 'active' : ''; ?>" href="profile.php">
                    <i class="fas fa-user"></i> My Profile
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo in_array($currentPage, ['studies.php', 'create-study.php', 'edit-study.php']) ? 'active' : ''; ?>" href="studies.php">
                    <i class="fas fa-flask"></i> My Studies
                    <?php if ($studiesCount > 0): ?>
                        <span class="badge bg-primary ms-1"><?php echo $studiesCount; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'connections.php' ? 'active' : ''; ?>" href="connections.php">
                    <i class="fas fa-user-friends"></i> Connections
                    <?php if ($pendingConnections > 0): ?>
                        <span class="badge bg-warning ms-1"><?php echo $pendingConnections; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'collaborations.php' ? 'active' : ''; ?>" href="collaborations.php">
                    <i class="fas fa-users"></i> Collaborations
                    <?php if ($pendingInvitations > 0): ?>
                        <span class="badge bg-warning ms-1"><?php echo $pendingInvitations; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo in_array($currentPage, ['messages.php', 'messages-enhanced.php']) ? 'active' : ''; ?>" href="messages-enhanced.php">
                    <i class="fas fa-envelope"></i> Messages
                    <?php if ($unreadMessages > 0): ?>
                        <span class="badge bg-danger ms-1"><?php echo $unreadMessages; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo in_array($currentPage, ['notifications.php', 'notifications-enhanced.php']) ? 'active' : ''; ?>" href="notifications-enhanced.php">
                    <i class="fas fa-bell"></i> Notifications
                    <?php if ($unreadNotifications > 0): ?>
                        <span class="badge bg-danger ms-1"><?php echo $unreadNotifications; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'settings.php' ? 'active' : ''; ?>" href="settings.php">
                    <i class="fas fa-cog"></i> Settings
                </a>
            </li>
        </ul>
    </div>
</nav>

<style>
.sidebar {
    position: fixed;
    top: 56px;
    left: 0;
    bottom: 0;
    z-index: 100;
    padding: 0;
    box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
    overflow-y: auto;
    height: calc(100vh - 56px);
}

.sidebar .nav-link {
    font-weight: 500;
    color: #333;
    padding: 0.75rem 1rem;
    border-left: 3px solid transparent;
    transition: all 0.2s ease;
}

.sidebar .nav-link:hover {
    background-color: #f8f9fa;
    color: #007bff;
}

.sidebar .nav-link.active {
    color: #007bff;
    background-color: #e7f3ff;
    border-left: 3px solid #007bff;
}

.sidebar .nav-link i {
    margin-right: 0.5rem;
    width: 20px;
    text-align: center;
}

.sidebar .badge {
    font-size: 0.7rem;
    padding: 0.25em 0.4em;
}

/* Ensure main content doesn't overlap with sidebar */
.main-content {
    margin-left: 16.666667%; /* col-md-3 equivalent */
    margin-top: 56px;
    padding: 20px;
}

/* Responsive behavior */
@media (max-width: 767.98px) {
    .sidebar {
        position: static;
        height: auto;
    }
    
    .main-content {
        margin-left: 0;
    }
}
</style>

<!-- Add this if you want mobile toggle functionality -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Toggle sidebar on mobile (optional)
    const sidebarToggle = document.querySelector('[data-bs-toggle="collapse"]');
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', function() {
            document.getElementById('sidebarMenu').classList.toggle('show');
        });
    }
});
</script>