<?php
// Determine the correct path to config
$configPath = '';
if (file_exists(__DIR__ . '/../config/config.php')) {
    $configPath = __DIR__ . '/../config/config.php';
} elseif (file_exists(dirname(dirname(__FILE__)) . '/config/config.php')) {
    $configPath = dirname(dirname(__FILE__)) . '/config/config.php';
}

if ($configPath && !defined('ROOT_PATH')) {
    require_once $configPath;
}

// Initialize database connection for user profile picture
$db = getDB();

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$pageTitle = $pageTitle ?? SITE_NAME;
$flashMessage = getFlashMessage();

// Get contact info
$headerContactInfo = getContactInfo();
$headerCompanyName = !empty($headerContactInfo['company_name']) ? $headerContactInfo['company_name'] : getSiteName();
$logoUrl = getLogoUrl();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($pageTitle); ?> - <?php echo e(getSiteName()); ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    
    <!-- AOS (Animate On Scroll) CSS -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo SITE_URL_DYNAMIC; ?>/assets/css/style.css">
    
    <style>
        /* Mobile-specific styles */
        body {
            overflow-x: hidden;
            padding-top: 60px; /* Fixed header height */
            padding-bottom: 80px; /* Fixed footer height */
        }

        /* Fixed Mobile Header */
        .mobile-header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            background: #fff;
            border-bottom: 1px solid #e9ecef;
            box-shadow: 0 2px 4px rgba(0,0,0,0.08);
            height: 60px;
        }

        .mobile-header .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 8px 16px;
            height: 100%;
        }

        .mobile-header .header-left {
            display: flex;
            align-items: center;
            gap: 12px;
            flex: 1;
        }

        .mobile-header .header-center {
            flex: 2;
            text-align: center;
        }

        .mobile-header .header-right {
            display: flex;
            align-items: center;
            gap: 8px;
            flex: 1;
            justify-content: flex-end;
        }

        .mobile-header .page-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin: 0;
            color: #1c1e21;
        }

        .mobile-header .btn-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: transparent;
            border: none;
            color: #050505;
            transition: background-color 0.2s;
            padding: 0;
        }

        .mobile-header .btn-icon:hover,
        .mobile-header .btn-icon:active {
            background-color: #f0f2f5;
        }

        .mobile-header .btn-icon i {
            font-size: 1.2rem;
        }

        .mobile-header .logo-img {
            height: 36px;
            width: auto;
        }

        /* Header Quick Nav */
        .header-quick-nav {
            display: flex;
            gap: 4px;
            align-items: center;
            justify-content: center;
        }

        .quick-nav-link {
            width: 44px;
            height: 44px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #65676b;
            text-decoration: none;
            transition: all 0.2s;
        }

        .quick-nav-link:hover,
        .quick-nav-link.active {
            background: #f0f2f5;
            color: #0d6efd;
        }

        .quick-nav-link i {
            font-size: 1.1rem;
        }

        /* Offcanvas Menu */
        .mobile-offcanvas {
            width: 300px;
        }

        .mobile-offcanvas .offcanvas-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .mobile-offcanvas .nav-section {
            padding: 16px;
            border-bottom: 1px solid #e9ecef;
        }

        .mobile-offcanvas .nav-section:last-child {
            border-bottom: none;
        }

        .mobile-offcanvas .nav-section-title {
            font-weight: 600;
            color: #495057;
            margin-bottom: 12px;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .mobile-offcanvas .nav-link {
            padding: 10px 12px;
            color: #333;
            border-radius: 8px;
            margin-bottom: 4px;
            transition: all 0.2s;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .mobile-offcanvas .nav-link:hover {
            background: #f0f2f5;
            color: #0d6efd;
        }

        .mobile-offcanvas .nav-link.active {
            background: #0d6efd;
            color: white;
        }

        .mobile-offcanvas .nav-link i {
            width: 20px;
            text-align: center;
        }

        .mobile-offcanvas .social-links {
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
            margin-top: 8px;
        }

        .mobile-offcanvas .social-link {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #f8f9fa;
            color: #6c757d;
            text-decoration: none;
            transition: all 0.2s;
        }

        .mobile-offcanvas .social-link:hover {
            background: #0d6efd;
            color: white;
            transform: translateY(-2px);
        }

        .mobile-offcanvas .contact-info {
            font-size: 0.85rem;
            color: #6c757d;
            margin-top: 12px;
        }

        .mobile-offcanvas .contact-info a {
            color: #6c757d;
            text-decoration: none;
        }

        .mobile-offcanvas .contact-info a:hover {
            color: #0d6efd;
        }

        /* Main Content Area */
        .mobile-content-wrapper {
            min-height: calc(100vh - 60px);
        }
    </style>
    
    <?php if (isset($additionalCSS)): ?>
        <?php echo $additionalCSS; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Fixed Mobile Header -->
    <header class="mobile-header">
        <div class="header-content">
            <!-- Left: Menu Button & Logo -->
            <div class="header-left">
                <button class="btn-icon" type="button" data-bs-toggle="offcanvas" data-bs-target="#mobileMenu">
                    <i class="fas fa-bars"></i>
                </button>
                
                <?php if ($logoUrl && file_exists(str_replace(SITE_URL_DYNAMIC, ROOT_PATH, $logoUrl))): ?>
                    <img src="<?php echo $logoUrl; ?>" alt="<?php echo e($headerCompanyName); ?>" class="logo-img">
                <?php elseif (file_exists(ROOT_PATH . '/assets/images/logo.png')): ?>
                    <img src="<?php echo SITE_URL_DYNAMIC; ?>/assets/images/logo.png" alt="<?php echo e($headerCompanyName); ?>" class="logo-img">
                <?php endif; ?>
            </div>

            <!-- Center: Quick Nav Links -->
            <div class="header-center">
                <div class="header-quick-nav">
                    <a href="<?php echo SITE_URL_DYNAMIC; ?>/index.php" class="quick-nav-link <?php echo $currentPage === 'index' ? 'active' : ''; ?>">
                        <i class="fas fa-home"></i>
                    </a>
                    <a href="<?php echo SITE_URL_DYNAMIC; ?>/public/studies.php" class="quick-nav-link <?php echo $currentPage === 'studies' ? 'active' : ''; ?>">
                        <i class="fas fa-flask"></i>
                    </a>
                    <a href="<?php echo SITE_URL_DYNAMIC; ?>/public/researchers.php" class="quick-nav-link <?php echo $currentPage === 'researchers' ? 'active' : ''; ?>">
                        <i class="fas fa-users"></i>
                    </a>
                    <a href="<?php echo SITE_URL_DYNAMIC; ?>/public/publications.php" class="quick-nav-link <?php echo $currentPage === 'publications' ? 'active' : ''; ?>">
                        <i class="fas fa-book"></i>
                    </a>
                </div>
            </div>

            <!-- Right: User Actions -->
            <div class="header-right">
                <?php if (isLoggedIn()): ?>
                    <!-- Notification button removed -->
                <?php endif; ?>
            </div>
        </div>
    </header>

    <!-- Offcanvas Menu -->
    <div class="offcanvas offcanvas-start mobile-offcanvas" tabindex="-1" id="mobileMenu">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title">
                <img src="<?php echo SITE_URL_DYNAMIC; ?>/assets/images/logo_white.png" alt="<?php echo e($headerCompanyName); ?>" height="24" class="me-2">
                <?php echo e($headerCompanyName); ?>
            </h5>
            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
        </div>
        <div class="offcanvas-body p-0">
            <!-- Quick Links Section -->
            <div class="nav-section">
                <div class="nav-section-title">Quick Links</div>
                <nav class="nav flex-column">
                    <a class="nav-link <?php echo $currentPage === 'index' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/index.php">
                        <i class="fas fa-home"></i> Home
                    </a>
                    <a class="nav-link <?php echo $currentPage === 'about' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/about.php">
                        <i class="fas fa-info-circle"></i> About
                    </a>
                    <a class="nav-link <?php echo $currentPage === 'studies' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/studies.php">
                        <i class="fas fa-flask"></i> Studies
                    </a>
                    <a class="nav-link <?php echo $currentPage === 'researchers' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/researchers.php">
                        <i class="fas fa-users"></i> Researchers
                    </a>
                </nav>
            </div>

            <!-- Resources Section -->
            <div class="nav-section">
                <div class="nav-section-title">Resources</div>
                <nav class="nav flex-column">
                    <a class="nav-link <?php echo $currentPage === 'publications' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/publications.php">
                        <i class="fas fa-book"></i> Publications
                    </a>
                    <a class="nav-link <?php echo $currentPage === 'help' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/help.php">
                        <i class="fas fa-question-circle"></i> Help Center
                    </a>
                    <a class="nav-link <?php echo $currentPage === 'faq' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/faq.php">
                        <i class="fas fa-question"></i> FAQ
                    </a>
                    <a class="nav-link <?php echo $currentPage === 'contact' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/contact.php">
                        <i class="fas fa-envelope"></i> Contact
                    </a>
                </nav>
            </div>

            <!-- Legal Section -->
            <div class="nav-section">
                <div class="nav-section-title">Legal</div>
                <nav class="nav flex-column">
                    <a class="nav-link <?php echo $currentPage === 'privacy' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/privacy.php">
                        <i class="fas fa-shield-alt"></i> Privacy Policy
                    </a>
                    <a class="nav-link <?php echo $currentPage === 'terms' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/terms.php">
                        <i class="fas fa-file-contract"></i> Terms of Service
                    </a>
                    <a class="nav-link <?php echo $currentPage === 'compliance' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/compliance.php">
                        <i class="fas fa-check-circle"></i> Compliance
                    </a>
                </nav>
            </div>

            <!-- Connect Section -->
            <div class="nav-section">
                <div class="nav-section-title">Connect</div>
                <div class="social-links">
                    <?php
                    $socialMedia = getSocialMediaLinks();
                    $socialIcons = [
                        'facebook' => 'fab fa-facebook',
                        'twitter' => 'fab fa-twitter',
                        'linkedin' => 'fab fa-linkedin',
                        'instagram' => 'fab fa-instagram',
                        'youtube' => 'fab fa-youtube',
                        'researchgate' => 'fab fa-researchgate',
                        'orcid' => 'fab fa-orcid'
                    ];
                    
                    foreach ($socialMedia as $platform => $url):
                        if (!empty($url) && isset($socialIcons[$platform])):
                    ?>
                        <a href="<?php echo e($url); ?>" target="_blank" class="social-link" title="<?php echo ucfirst($platform); ?>">
                            <i class="<?php echo $socialIcons[$platform]; ?>"></i>
                        </a>
                    <?php 
                        endif;
                    endforeach;
                    
                    // Show default icons if no social media configured
                    if (empty($socialMedia)):
                    ?>
                        <a href="#" class="social-link"><i class="fab fa-facebook"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-linkedin"></i></a>
                        <a href="#" class="social-link"><i class="fab fa-researchgate"></i></a>
                    <?php endif; ?>
                </div>
                
                <?php 
                $contactInfo = getContactInfo();
                if (!empty($contactInfo['email_primary']) || !empty($contactInfo['phone_primary'])):
                ?>
                <div class="contact-info">
                    <?php if (!empty($contactInfo['email_primary'])): ?>
                        <div class="mb-2">
                            <i class="fas fa-envelope me-2"></i>
                            <a href="mailto:<?php echo e($contactInfo['email_primary']); ?>">
                                <?php echo e($contactInfo['email_primary']); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($contactInfo['phone_primary'])): ?>
                        <div>
                            <i class="fas fa-phone me-2"></i>
                            <a href="tel:<?php echo e($contactInfo['phone_primary']); ?>">
                                <?php echo e($contactInfo['phone_primary']); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>

            <!-- Auth Links -->
            <div class="nav-section">
                <?php if (isLoggedIn()): ?>
                    <!-- User Profile Section -->
                    <div class="user-profile-section text-center mb-3">
                        <?php
                        // Get current user's profile picture
                        $currentUserId = getCurrentUserId();
                        $userPhoto = null;
                        $userName = $_SESSION['user_name'] ?? 'User';
                        if ($currentUserId) {
                            $stmt = $db->prepare("SELECT photo FROM researcher_profiles WHERE user_id = ?");
                            $stmt->execute([$currentUserId]);
                            $profileData = $stmt->fetch();
                            $userPhoto = $profileData['photo'] ?? null;
                        }
                        ?>
                        <?php if ($userPhoto): ?>
                            <img src="<?php echo getProfilePictureUrl($userPhoto); ?>" 
                                 alt="Profile" 
                                 class="rounded-circle mb-2" 
                                 style="width: 60px; height: 60px; object-fit: cover;">
                        <?php else: ?>
                            <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-2" 
                                 style="width: 60px; height: 60px; font-size: 24px;">
                                <?php echo strtoupper(substr(explode(' ', $userName)[0], 0, 1) . substr(explode(' ', $userName)[1] ?? '', 0, 1)); ?>
                            </div>
                        <?php endif; ?>
                        <div class="fw-bold"><?php echo e($userName); ?></div>
                        <a href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/profile.php" class="btn btn-sm btn-outline-primary mt-2">
                            <i class="fas fa-user"></i> View Profile
                        </a>
                    </div>
                    
                    <a href="<?php echo SITE_URL_DYNAMIC; ?>/logout.php" class="btn btn-outline-danger w-100">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                <?php else: ?>
                    <div class="d-grid gap-2">
                        <a href="<?php echo SITE_URL_DYNAMIC; ?>/login.php" class="btn btn-primary">
                            <i class="fas fa-sign-in-alt"></i> Login
                        </a>
                        <a href="<?php echo SITE_URL_DYNAMIC; ?>/register.php" class="btn btn-outline-primary">
                            <i class="fas fa-user-plus"></i> Register
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Flash Messages -->
    <?php if ($flashMessage): ?>
        <div class="container mt-2 px-3">
            <div class="alert alert-<?php echo $flashMessage['type'] === 'error' ? 'danger' : $flashMessage['type']; ?> alert-dismissible fade show" role="alert">
                <?php echo e($flashMessage['message']); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>

    <!-- Main Content Wrapper -->
    <main class="mobile-content-wrapper py-4">
