<?php
require_once 'config/config.php';

try {
    $db = getDB();
    
    echo "<h2>Contact Requests Table Structure:</h2>";
    $stmt = $db->query('DESCRIBE contact_requests');
    echo "<table border='1'><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th></tr>";
    while($row = $stmt->fetch()) {
        echo "<tr>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h2>Sample Data:</h2>";
    $stmt = $db->query('SELECT * FROM contact_requests LIMIT 5');
    $data = $stmt->fetchAll();
    echo "<pre>" . print_r($data, true) . "</pre>";
    
} catch (Exception $e) {
    echo "<h2>Error:</h2>";
    echo "<p style='color: red;'>" . $e->getMessage() . "</p>";
    echo "<p>The contact_requests table does not exist in the database.</p>";
}
?>
