<?php
// Determine the correct path to config
$configPath = '';
if (file_exists(__DIR__ . '/../config/config.php')) {
    $configPath = __DIR__ . '/../config/config.php';
} elseif (file_exists(dirname(dirname(__FILE__)) . '/config/config.php')) {
    $configPath = dirname(dirname(__FILE__)) . '/config/config.php';
}

if ($configPath && !defined('ROOT_PATH')) {
    require_once $configPath;
}

// Initialize database connection for user profile picture
$db = getDB();

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$pageTitle = $pageTitle ?? SITE_NAME;
$flashMessage = getFlashMessage();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!-- Content Security Policy for external CDNs -->
    <meta http-equiv="Content-Security-Policy" content="default-src 'self'; style-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://unpkg.com; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://unpkg.com https://code.jquery.com; font-src 'self' https://cdnjs.cloudflare.com; img-src 'self' data: https:;">
    <title><?php echo e($pageTitle); ?> - <?php echo e(getSiteName()); ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Swiper CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    
    <!-- AOS (Animate On Scroll) CSS -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo SITE_URL_DYNAMIC; ?>/assets/css/style.css">
    
    <?php if (isset($additionalCSS)): ?>
        <?php echo $additionalCSS; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <?php 
            $headerContactInfo = getContactInfo();
            $headerCompanyName = !empty($headerContactInfo['company_name']) ? $headerContactInfo['company_name'] : getSiteName();
            $headerTagline = !empty($headerContactInfo['tagline']) ? $headerContactInfo['tagline'] : '';
            $logoUrl = getLogoUrl();
            ?>
            <a class="navbar-brand d-flex align-items-center gap-3 py-0" href="<?php echo SITE_URL_DYNAMIC; ?>/index.php" style="min-height:72px;">
                <?php if ($logoUrl && file_exists(str_replace(SITE_URL_DYNAMIC, ROOT_PATH, $logoUrl))): ?>
                    <img src="<?php echo $logoUrl; ?>" alt="<?php echo e($headerCompanyName); ?>" height="72" class="d-inline-block align-text-top" style="max-width:72px;">
                <?php elseif (file_exists(ROOT_PATH . '/assets/images/logo_white.png')): ?>
                    <img src="<?php echo SITE_URL_DYNAMIC; ?>/assets/images/logo_white.png" alt="<?php echo e($headerCompanyName); ?>" height="72" class="d-inline-block align-text-top" style="max-width:72px;">
                <?php else: ?>
                    <img src="<?php echo SITE_URL_DYNAMIC; ?>/assets/images/logo.png" alt="<?php echo e($headerCompanyName); ?>" height="72" class="d-inline-block align-text-top" style="max-width:72px;">
                <?php endif; ?>
                <span class="d-flex flex-column justify-content-center">
                    <span class="fw-bold lh-1" style="font-size:2rem; line-height:1.1;"><?php echo e($headerCompanyName); ?></span>
                    <?php if ($headerTagline): ?>
                        <span class="text-white-50 fst-italic lh-1" style="font-size:1.05rem; line-height:1.1; margin-top:2px;"><?php echo e($headerTagline); ?></span>
                    <?php endif; ?>
                </span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <?php
                // Dynamic Menu Integration - Uncomment to use CMS menus
                // $headerMenu = displayMenu('header', 'navbar-nav me-auto');
                // if ($headerMenu) {
                //     echo $headerMenu;
                // } else {
                //     // Fallback to static menu if no CMS menu exists
                ?>
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link <?php echo $currentPage == 'index' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/index.php">
                            <i class="fas fa-home"></i> Home
                        </a>
                    </li>
                    
                    <?php if (isLoggedIn()): ?>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $currentPage == 'studies' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/studies.php">
                                <i class="fas fa-flask"></i> Studies
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $currentPage == 'researchers' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/researchers.php">
                                <i class="fas fa-users"></i> Researchers
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $currentPage == 'publications' ? 'active' : ''; ?>" href="<?php echo SITE_URL_DYNAMIC; ?>/public/publications.php">
                                <i class="fas fa-book"></i> Publications
                            </a>
                        </li>
                        
                        <?php if (isResearcher() || isInstitutionAdmin() || isSuperAdmin()): ?>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle" href="#" id="researcherDropdown" role="button" data-bs-toggle="dropdown">
                                    <i class="fas fa-user-md"></i> My Research
                                </a>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/dashboard.php">
                                        <i class="fas fa-tachometer-alt"></i> Dashboard
                                    </a></li>
                                    <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/profile.php">
                                        <i class="fas fa-user"></i> My Profile
                                    </a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/studies.php">
                                        <i class="fas fa-flask"></i> My Studies
                                    </a></li>
                                    <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/collaborations.php">
                                        <i class="fas fa-users"></i> Collaborations
                                    </a></li>
                                    <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/connections.php">
                                        <i class="fas fa-user-friends"></i> Connections
                                    </a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/messages-enhanced.php">
                                        <i class="fas fa-envelope"></i> Messages
                                    </a></li>
                                    <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/notifications-enhanced.php">
                                        <i class="fas fa-bell"></i> Notifications
                                    </a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/settings.php">
                                        <i class="fas fa-cog"></i> Settings
                                    </a></li>
                                </ul>
                            </li>
                        <?php endif; ?>
                        
                        <?php if (canAccessAdminPanel()): ?>
                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo SITE_URL_DYNAMIC; ?>/admin/dashboard.php">
                                    <i class="fas fa-cog"></i> Admin
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo SITE_URL_DYNAMIC; ?>/public/studies.php">
                                <i class="fas fa-flask"></i> Studies
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo SITE_URL_DYNAMIC; ?>/public/researchers.php">
                                <i class="fas fa-users"></i> Researchers
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo SITE_URL_DYNAMIC; ?>/public/publications.php">
                                <i class="fas fa-book"></i> Publications
                            </a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="moreDropdown" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-ellipsis-h"></i> More
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/public/about.php">About Us</a></li>
                                <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/public/institutions.php">Institutions</a></li>
                                <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/public/contact.php">Contact</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/public/help.php">Help Center</a></li>
                                <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/public/faq.php">FAQ</a></li>
                            </ul>
                        </li>
                    <?php endif; ?>
                </ul>
                <?php
                // } // End of fallback menu
                ?>
                
                <ul class="navbar-nav">
                    <?php if (isLoggedIn()): ?>
                        <!-- Notifications -->
                        <li class="nav-item dropdown">
                            <a class="nav-link position-relative" href="#" id="notificationsDropdown" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-bell"></i>
                                <?php 
                                $unreadCount = getUnreadNotificationsCount(getCurrentUserId());
                                if ($unreadCount > 0): 
                                ?>
                                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                        <?php echo $unreadCount > 9 ? '9+' : $unreadCount; ?>
                                    </span>
                                <?php endif; ?>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end" style="min-width: 300px;">
                                <li><h6 class="dropdown-header">Notifications</h6></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-center small" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/notifications.php">View All Notifications</a></li>
                            </ul>
                        </li>
                        
                        <!-- User Menu -->
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                                <?php
                                // Get current user's profile picture
                                $currentUserId = getCurrentUserId();
                                $userPhoto = null;
                                if ($currentUserId) {
                                    $stmt = $db->prepare("SELECT photo FROM researcher_profiles WHERE user_id = ?");
                                    $stmt->execute([$currentUserId]);
                                    $profileData = $stmt->fetch();
                                    $userPhoto = $profileData['photo'] ?? null;
                                }
                                ?>
                                <?php if ($userPhoto): ?>
                                    <img src="<?php echo getProfilePictureUrl($userPhoto); ?>" 
                                         alt="Profile" 
                                         class="rounded-circle me-2" 
                                         style="width: 32px; height: 32px; object-fit: cover;">
                                <?php else: ?>
                                    <i class="fas fa-user-circle me-2"></i>
                                <?php endif; ?>
                                <?php echo e($_SESSION['user_name'] ?? 'User'); ?>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/profile.php">
                                    <i class="fas fa-user"></i> My Profile
                                </a></li>
                                <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/researcher/settings.php">
                                    <i class="fas fa-cog"></i> Settings
                                </a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?php echo SITE_URL_DYNAMIC; ?>/logout.php">
                                    <i class="fas fa-sign-out-alt"></i> Logout
                                </a></li>
                            </ul>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo SITE_URL_DYNAMIC; ?>/login.php">
                                <i class="fas fa-sign-in-alt"></i> Login
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo SITE_URL_DYNAMIC; ?>/register.php">
                                <i class="fas fa-user-plus"></i> Register
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
    
    <!-- Flash Messages -->
    <?php if ($flashMessage): ?>
        <div class="container mt-3">
            <div class="alert alert-<?php echo $flashMessage['type'] === 'error' ? 'danger' : $flashMessage['type']; ?> alert-dismissible fade show" role="alert">
                <?php echo e($flashMessage['message']); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Main Content -->
    <main class="py-4">
